﻿<?LassoScript
	
	/*
			This page lists all the of forums available in the message board The
		forums are placed into 1 or more groups. These groups are described in
		their own table.

		forum_groups 
			id 
			position - controls the ordering when groups are listed 
			title - the name of the group

			The position column controls the ordering of the groups. When we
		select the groups for display, we sort on that column.
	*/
	
	/*
			Check to see if the admin is creating a new forum group
	*/
	if ($isAdmin && action_param('newGroup'));
		local('newGroup' = action_param('newGroup'));
		// find the highest group position and insert after that
		inline(-database='op_message_board', -table='forum_groups', -findall, 
				-maxrecords=1, -useLimit, -sortField='position', -sortOrder='descending', -returnField='position');
			inline(-table='forum_groups', -add, 
					'title'=#newGroup, 'position'=integer(field('position'))+1);
			/inline;
		/inline;
	/if;
	
	/*
			Check to see if the admin is creating a new forum
	*/
	if ($isAdmin && action_param('newForum') && action_param('groupId'));
		local('newForum' = action_param('newForum'), 
				'groupId' = action_param('groupId'),
				'desc' = action_param('desc'));
		// find the highest forum position and insert after that
		inline(-database='op_message_board', -table='forums', 	-search, 
				-op='eq', 'id_group'=#groupId, -sortField='position', -sortOrder='descending',
				-returnField='position');
			inline(-table='forums', -add, 'title'=#newForum, 'id_group'=#groupId, 
					'description'=#desc, 'position'=integer(field('position'))+1);
			/inline;
		/inline;		
	/if;
	/*
			Check to see if the admin is deleting a group, including all forums and msgs in those forums
	*/
	if ($isAdmin && action_param('delgid'));
		local('delGID' = action_param('delgid'));
		// first delete the forums in this group
		inline(-database='op_message_board', -table='forums', -search, -op='eq', 'id_group'=action_param('delgid'),
				-returnField='id');
			// delete all the messages in each forum
			records;
				inline(-table='messages', -keyField='id_forum', -keyValue=field('id'), -delete);/inline;
			/records;
			inline(-table='forums', -keyField='id_group', -keyValue=#delGID, -delete);/inline;
			inline(-table='forum_groups', -keyField='id', -keyValue=#delGID, -delete);/inline;
		/inline;
	/if;
	/*
			Check to see if the admin is deleting a forum, including all msgs in that forum
	*/
	if ($isAdmin && action_param('delfid'));
		local('delFID' = action_param('delfid'));
		// first delete the forums in this group
		inline(-database='op_message_board');
			inline(-table='messages', -keyField='id_forum', -keyValue=#delFID, -delete);/inline;
			inline(-table='forums', -keyField='id', -keyValue=#delFID, -delete);/inline;
		/inline;
	/if;
	/*
			Here we will select all the available groups. And place the
		information into the following variables.
	*/
	local('groupIds'=array, 'groupTitles'=array);
	inline(-database='op_message_board', -table='forum_groups', -findall, -sortField='position',
			-returnField='id', -returnField='title');

		fail_if(error_code != error_code_noerr, error_code, error_msg);

		if (found_count == 0);
	/*
			If there are no groups, let's create one
	*/
			inline(-table='forum_groups', -add, 'id'=1, 'title'='Forums', 'position'=0);

				fail_if(error_code != error_code_noerr, error_code, error_msg);
				
				#groupIds->insert(1);
				#groupTitles->insert('Forums');
			/inline;
		else;
	/*
			Otherwise, let's loop through the result set and pull out the 
		information we are interested in
	*/
			records;
				#groupIds->insert(integer(field('id')));
				#groupTitles->insert(encode_html(field('title')));
			/records;
		/if;
	/inline;

	'<div class="left_bar">\
	<b class="rboth1 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth4 rleftclr"></b>';
	'<span class="group_title" id="login_info" xmlns="http://www.w3.org/1999/xhtml">\
	Hello, <i>'admin_currentusername'</i>';
	if (!$isLoggedIn);
		' <a href="' Application_appInfo->indexFile '?auth=1">(login)</a>';
	/if;
	'</span>';
	'<b class="rboth4 rleftclr"></b><b class="rboth3 rleftclr"></b><b class="rboth2 rleftclr"></b><b class="rboth1 rleftclr"></b>';
	'</div>';

	/*
		Start the forums list display
	*/
	'<div class="group_list">';
	/*
			Loop through each group that we found earlier. There are an equal
		number of elements in each of the two arrays, so we will use iterate to
		move through the groupIds, and then pull out the group title based on
		position using loop_count.
		
		We will use a variable, curr, to hold each id as we do so.
	*/	
		iterate(#groupIds, local('curr'));
			'<div class="group">\
				<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
				<div class="group_title">'
					#groupTitles->get(loop_count);
				$isAdmin? (' - <a class="delete" href="' Application_appInfo->indexFile '?delgid='#curr'">(delete group)</a>');				
				'</div>';
	/*
			Now search for all the forums in this group. The forums are stored
		in their own table. We will search in the forums table based on the id
		of the current group. The forums have their own position column which
		controls the order in which they are displayed.

		forums
			id
			id_group - the id of the group the forum is in
			position - controls the ordering when forums are listed
			title - the name of the forum
			description - the description for the forum
	*/
				inline(-database='op_message_board', -table='forums', 	-search, 
						-op='eq', 'id_group'=#curr, -sortField='position',
						-returnField='id', -returnField='title', -returnField='description');
	/*
		Loop through each forum in this group and output the display.
	*/
					records;
						'<div class="item">\
							<div class="item_title">\
								<a href="' Application_appInfo->indexFile '?list=' field('id') '">' encode_html(field('title')) '</a>';
								$isAdmin? (' - <a class="delete" href="' Application_appInfo->indexFile '?delfid='field('id')'">(delete forum)</a>');	
							'</div>\
							<div class="item_description">'
								encode_html(field('description'))
							'</div>\
							<div class="item_details">';
	/*
			Display the total number of messages in this forum We could resort
		to -sql to do this more effeciently, but that would involve enabling sql
		execute permissions for the anonymous user
	*/
								inline(-table='messages', -search, -op='eq', 'id_forum'=field('id'), -returnField='id');
									found_count + (found_count == 1 ? ' Message' | ' Messages');
								/inline;
								
	/*
			Display the date and author of the last post. We could resort to -sql
		to do this more effeciently, but that would involve enabling sql execute
		permissions for the anonymous user
	*/
								inline(-table='messages', -search, -op='eq', 'id_forum'=field('id'),  -useLimit, -maxrecords=1, 
										-sortField='date', -sortOrder='descending',
										-returnField='id_author', -returnField='date');
									if (found_count != 0);
										', Last message posted on ' field('date') ' by '
										encode_html(MessageBoard_findAuthorById(field('id_author')));
									/if;
								/inline;
							'</div>\
						</div>';
					/records;
	/*
			Add the control for making a new forum group if the current user is an admin
	*/
					if ($isAdmin);					
						'<div class="item">\
						<form method="POST" action="' Application_appInfo->indexFile '">\
							<input type="hidden" name="groupId" value="'#curr'" />\
							New Forum Name<br />\
							<input type="text" name="newForum" /><br />\
							Description<br />\
							<input type="text" name="desc" size="50" /><br />\
							<input type="submit" name="Create" value="Create" />\
						</form>\
						</div>';
					/if;
				/inline;
			'</div>';
		/iterate;
	/*
			Add the control for making a new forum group if the current user is an admin
	*/
		if ($isAdmin);
			'<div class="group">\
				<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
				<div class="group_title">'
					'New Forum Group';
				'</div>\
				<div class="item">\
					<form method="POST" action="' Application_appInfo->indexFile '">\
						Group Name<br />\
						<input type="text" name="newGroup" />\
						<br /><input type="submit" name="Create" value="Create" />\
					</form>\
				</div>\
			</div>';
		/if;
	'</div>';

	
?>